/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (PatchFred.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: PatchFred.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx.demo;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.fremo.ihx.HexFileReader;
import org.fremo.ihx.HexFileWriter;
import org.fremo.ihx.InvalidHexFileException;
import org.fremo.ihx.Memory;

/**
 * @author martin
 *
 * Patch the id, adcMin and adcFactor values of a FRED.
 * arg[0] is the input file
 * arg[1] is the output file
 */
public class PatchFred {

    private String inf, outf;
    private Memory mem;
    public final static int EEPROM_BASE = 0x4200;

    public PatchFred(String inf, String outf) {
        super();
        this.inf = inf;
        this.outf = outf;
    }
    
    public void read() 
    throws InvalidHexFileException, IOException 
    {
        FileReader fr = new FileReader(inf);
        HexFileReader hfr = new HexFileReader(fr);
        mem = hfr.read();
        hfr.close();
        fr.close();
    }
    
    public void patch( int id1, int id2, int adcMin, int adcFactor) 
    {
        mem.set( EEPROM_BASE+0x06, id1 );
        mem.set( EEPROM_BASE+0x08, id2 );
        mem.set( EEPROM_BASE+0x0A, adcMin%0x100 );
        mem.set( EEPROM_BASE+0x0C, adcMin/0x100 );
        mem.set( EEPROM_BASE+0x0E, adcFactor );
    }

    public void write() 
    throws IOException 
    {
        FileWriter fw = new FileWriter(outf);
        HexFileWriter hfw = new HexFileWriter(fw);
        hfw.write( mem );
        hfw.close();
        fw.close();
    }
    
    public static void main(String[] args) {
        if( args.length < 2 ) {
            System.out.println("usage: PatchFred <input> <output>");
            return;
        }
        try {
            PatchFred pf = new PatchFred(args[0],args[1]);
            pf.read();
            pf.patch( 0x42, 0x33, 0x1234, 0x88 );
            pf.write();
        } catch (InvalidHexFileException e) {
            System.err.println("invalid hexfile");
            System.err.println(e.getMessage());
        } catch (IOException e) {
            System.err.println("io error");
            System.err.println(e.getMessage());
        }
     }
    
}
